@REM Copyright Versata Corp. 2002
@echo off
@setlocal
@pushd %~dp0
@echo -------------------------------------------------------------------------
@echo Current folder : %~dp0
@echo Current script : %~nx0

set THISFOLDER=%~dp0
set THISSCRIPT=%~nx0
set REPODIR=
set EARFILE=
set EJBDIR=
set WARDIR=

:custom_shift
  if /i "%1"=="" (goto start) else (
    if /i "%1"=="-repository_dir" (set REPODIR=%2&shift) else (
      if /i "%1"=="-ejb_dir" (set EJBDIR=%2&shift) else (
        if /i "%1"=="-war_dir" (set WARDIR=%2&shift) else (
          if /i "%1"=="-earfile" (set EARFILE=%2&shift)
        )
      )
    )
  )
  shift
  goto custom_shift
  
:start
  set REPODIR=%REPODIR:"=%
  set REPODIR=%REPODIR:"=%
  set EARFILE=%EARFILE:"=%
  set EARFILE=%EARFILE:"=%
  set EJBDIR=%EJBDIR:"=%
  set EJBDIR=%EJBDIR:"=%
  set WARDIR=%WARDIR:"=%
  set WARDIR=%WARDIR:"=%
  if /i "%REPODIR%"=="=" (set REPODIR=)
  if /i "%EARFILE%"=="=" (set EARFILE=)
  if /i "%EJBDIR%"=="=" (set EJBDIR=)
  if /i "%WARDIR%"=="=" (set WARDIR=)
  if /i "%REPODIR%"==":=" (set REPODIR=)
  if /i "%EARFILE%"==":=" (set EARFILE=)
  if /i "%EJBDIR%"==":=" (set EJBDIR=)
  if /i "%WARDIR%"==":=" (set WARDIR=)
  call ws_ss_setcp.bat > _trash.txt&del _trash.txt
  set TEMPDIR=%VERSATA_HOME%\Temp
  if /i not "%EARFILE%"=="" (
    if not exist "%EARFILE%" (
      @echo Error : Ear file "%EARFILE%" does not exist.&goto finish
    )
  )
  if /i not "%EJBDIR%"=="" (
    if /i not exist "%EJBDIR%" (
      @echo Error : Ejb directory "%EJBDIR%" does not exist.&goto finish
    )
  )
  if /i not "%WARDIR%"=="" (
    if /i not exist "%WARDIR%" (
      @echo Error : War directory "%WARDIR%" does not exist.&goto finish
    )
  )
  if /i "%REPODIR%"=="" (
    @echo Error : You need to specify repository_dir.&call :usage&goto finish
  )
  if not exist "%REPODIR%" (
    @echo Error : Repository directory "%REPODIR%" does not exist.&goto finish
  )
  if not exist "%TEMPDIR%"  (mkdir "%TEMPDIR%")
  @echo Running %THISSCRIPT%
  @echo   VERSATA_HOME=%VERSATA_HOME%
  @echo   Input ear file : %EARFILE%
  @echo   Input ejb directory : %EJBDIR%
  @echo   Input war directory : %WARDIR%
  @echo   Output repository directory : %REPODIR%
  if /i not "%EARFILE%"=="" (call :import_ear_file)
  if /i not "%EJBDIR%"=="" (call :import_ejb_dir)
  if /i not "%WARDIR%"=="" (call :import_war_dir)
goto finish

:import_ear_file
  @echo -------------------------------------------------------------------------
  @echo Extracting "%EARFILE%" ...
  if exist "%TEMPDIR%\_ear" (rmdir "%TEMPDIR%\_ear" /s /q)
  mkdir "%TEMPDIR%\_ear"
  mkdir "%TEMPDIR%\_ear\_ejb"
  mkdir "%TEMPDIR%\_ear\_war"
  cd "%TEMPDIR%\_ear"
  jar -xvf "%EARFILE%"
  cd "%TEMPDIR%\_ear\_ejb"
  jar -xvf ..\*.jar
  cd "%TEMPDIR%\_ear\_war"
  jar -xvf ..\*.war
  @echo Extracting "%EARFILE%" ... (done)
  @echo -------------------------------------------------------------------------
  @echo Copying EJB source to repository ...
  cd "%TEMPDIR%\_ear\_ejb"
  dir /b /a-d /s *.java > .\_ejb.filelist
  call :copy_ejb_source
  del .\_ejb.filelist
  @echo Copying EJB source to repository ... (done)
  @echo -------------------------------------------------------------------------
  @echo Copying WAR source to repository ...
  cd "%TEMPDIR%\_ear\_war"
  dir /b /a-d /s *.java > .\_war.filelist
  call :copy_war_source
  del .\_war.filelist
  cd "%TEMPDIR%"
  rmdir .\_ear /s /q
  @echo Copying WAR source to repository ... (done)
  @echo -------------------------------------------------------------------------
goto end

:import_ejb_dir
  @echo -------------------------------------------------------------------------
  @echo Copying files from "%EJBDIR%" ...
  if exist "%TEMPDIR%\_ear" (rmdir "%TEMPDIR%\_ear" /s /q)
  mkdir "%TEMPDIR%\_ear"
  mkdir "%TEMPDIR%\_ear\_ejb"
  cd "%TEMPDIR%\_ear\_ejb"
  xcopy /s /f /e /r /c "%EJBDIR%\*.java" "%TEMPDIR%\_ear\_ejb\*.java"
  @echo Copying files from "%EJBDIR%" ... (done)
  @echo -------------------------------------------------------------------------
  @echo Copying EJB source to repository ...
  dir /b /a-d /s *.java > .\_ejb.filelist
  call :copy_ejb_source
  del .\_ejb.filelist
  cd "%TEMPDIR%"
  rmdir .\_ear /s /q
  @echo Copying EJB source to repository ... (done)
  @echo -------------------------------------------------------------------------
goto end

:import_war_dir
  @echo -------------------------------------------------------------------------
  @echo Copying files from "%WARDIR%" ...
  if exist "%TEMPDIR%\_ear" (rmdir "%TEMPDIR%\_ear" /s /q)
  mkdir "%TEMPDIR%\_ear"
  mkdir "%TEMPDIR%\_ear\_war"
  cd "%TEMPDIR%\_ear\_war"
  xcopy /s /f /e /r /c "%WARDIR%\*.java" "%TEMPDIR%\_ear\_war\*.java"
  @echo Copying files from "%WARDIR%" ... (done)
  @echo -------------------------------------------------------------------------
  @echo Copying WAR source to repository ...
  dir /b /a-d /s *.java > .\_war.filelist
  call :copy_war_source
  del .\_war.filelist
  cd "%TEMPDIR%"
  rmdir .\_ear /s /q
  @echo Copying WAR source to repository ... (done)
  @echo -------------------------------------------------------------------------
goto end

:copy_ejb_source
  for /f "eol=; Tokens=* Delims=" %%i in ('type .\_ejb.filelist') do call :parse_ejb_filelist "%%i"
goto end

:parse_ejb_filelist
  set LINE=%1
  set LINE=%LINE:"=%
  set SEARCH=%LINE%
  set TOKEN1=
  set TOKEN2=
  set FILE=
  :RESOLVE1
  for /f "tokens=1* delims=\" %%i in ('echo %SEARCH%') do set TOKEN1=%%i& set TOKEN2=%%j
  if /i not "%TOKEN2%"=="" (set SEARCH=%TOKEN2%& goto RESOLVE1)
  call :copy_ejb_file "%LINE%" "%TOKEN1%"
goto end

:copy_ejb_file
  set FULL=%1
  set FULL=%FULL:"=%
  set FILE=%2
  set FILE=%FILE:"=%
  set COPY=
  if exist "%REPODIR%\Cache\VLS\." (
    cd "%REPODIR%\Cache\VLS"
    for /f "Tokens=*" %%i in ('dir "%FILE%" /b /a-d /s') do if exist "%%i" (set COPY=%%i)
  )
  if exist "%REPODIR%\Source\VLS\." (
    cd "%REPODIR%\Source\VLS"
    for /f "Tokens=*" %%i in ('dir "%FILE%" /b /a-d /s') do if exist "%%i" (set COPY=%%i)
  )
  cd "%TEMPDIR%\_ear\_ejb"
  if /i not "%COPY%"=="" (@echo copying to: "%COPY%"&copy "%FULL%" "%COPY%")
goto end

:copy_war_source
  for /f "eol=; Tokens=* Delims=" %%i in ('type .\_war.filelist') do call :parse_war_filelist "%%i"
goto end

:parse_war_filelist
  set LINE=%1
  set LINE=%LINE:"=%
  set SEARCH=%LINE%
  set TOKEN1=
  set TOKEN2=
  set APPLICATION=
  :RESOLVE2
  for /f "tokens=1* delims=\" %%i in ('echo %SEARCH%') do set TOKEN1=%%i& set TOKEN2=%%j
  if /i not "%TOKEN2%"=="" (set APPLICATION=%TOKEN1%&set SEARCH=%TOKEN2%& goto RESOLVE2)
  call :copy_war_file "%APPLICATION%" "%LINE%" "%TOKEN1%"
goto end

:copy_war_file
  set APPLICATION=%1
  set APPLICATION=%APPLICATION:"=%
  set FULL=%2
  set FULL=%FULL:"=%
  set FILE=%3
  set FILE=%FILE:"=%
  set COPY=
  if exist "%REPODIR%\Cache\ClientApps\HTMLApps\%APPLICATION%.app\." (
    cd "%REPODIR%\Cache\ClientApps\HTMLApps\%APPLICATION%.app"
    for /f "Tokens=*" %%i in ('dir "%FILE%" /b /a-d /s') do if exist "%%i" (set COPY=%%i)
  )
  if exist "%REPODIR%\Source\ClientApps\HTMLApps\%APPLICATION%.app\." (
    cd "%REPODIR%\Source\ClientApps\HTMLApps\%APPLICATION%.app"
    for /f "Tokens=*" %%i in ('dir "%FILE%" /b /a-d /s') do if exist "%%i" (set COPY=%%i)
  )
  cd "%TEMPDIR%\_ear\_war"
  if /i not "%COPY%"=="" (@echo copying to: "%COPY%"&copy "%FULL%" "%COPY%")
goto end

:finish
  @popd
  @endlocal
goto end

:usage
  @echo Desc  : Import java source to Versata's repository.
  @echo Usage : wsEarImport.bat
  @echo         [-earfile {input ear file} -repository_dir {output repository directory]
  @echo         [-ejb_dir {input ejb directory} -repository_dir {output repository directory}]
  @echo         [-war_dir {input war directory} -repository_dir {output repository directory}]
  @echo Process aborted.
:end
